/*
 * Copyright (C) 2000 - 2024 Silverpeas
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * As a special exception to the terms and conditions of version 3.0 of
 * the GPL, you may redistribute this Program in connection with Free/Libre
 * Open Source Software ("FLOSS") applications as described in Silverpeas's
 * FLOSS exception.  You should have received a copy of the text describing
 * the FLOSS exception, and it is also available here:
 * "https://www.silverpeas.org/legal/floss_exception.html"
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General License for more details.
 *
 * You should have received a copy of the GNU Affero General License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.silverpeas.core.workflow.api.model;

import java.io.Serializable;

/**
 * Interface describing a representation of the &lt;relatedUser&gt; element of a Process Model.
 */
public interface RelatedUser extends Serializable {
  /**
   * Get the referred participant
   * @return Participant object
   */
  Participant getParticipant();

  /**
   * Set the referred participant
   * @param participant Participant object
   */
  void setParticipant(Participant participant);

  /**
   * Get the referred item
   */
  Item getFolderItem();

  /**
   * Set the referred item
   */
  void setFolderItem(Item item);

  /**
   * Get the relation between user and participant
   * @return relation, if null get the participant himself instead of searching related user
   */
  String getRelation();

  /**
   * set the relation between user and participant
   */
  void setRelation(String strRelation);

  /**
   * Get the role to which the related user will be affected
   * @return the role name
   */
  String getRole();

  /**
   * New method: Set the role the related user will be affected to
   */
  void setRole(String strRole);
}